# [Flask AdminLTE](https://app-generator.dev/product/adminlte/flask/)

**Open-source Flask Starter** built on top of **[AdminLTE](https://app-generator.dev/product/adminlte/)**, an open-source iconic `Bootstrap` design.
The product is designed to deliver the best possible user experience with highly customizable feature-rich pages. 

- 👉 [Flask AdminLTE](https://app-generator.dev/product/adminlte/flask/) - `Product Page`
- 👉 [Flask AdminLTE](https://flask-adminlte-demo.onrender.com/) - `LIVE Demo` 
- 👉 [Flask AdminLTE](https://app-generator.dev/docs/products/flask/adminlte/index.html) - `Documentation` (learn how to use the product) 

<br />

## Features

- Simple, Easy-to-Extend codebase, [Blueprint Pattern](https://app-generator.dev/blog/flask-blueprints-a-developers-guide/)
- [AdminLTE](https://app-generator.dev/product/adminlte/) Design Integration 
- [Bootstrap](https://app-generator.dev/docs/templates/bootstrap/index.html) Styling
- Session-based Authentication
- DB Persistence: SQLite (default), can be used with MySql, PgSql
- Apps:
  - Dynamic Tables - see [DEMO](https://flask-adminlte-demo.onrender.com/dynamic-dt/products)
  - Charts - see [DEMO](https://flask-adminlte-demo.onrender.com/charts)
- [Deployment](https://app-generator.dev/docs/deployment.html)
  - Docker/Docker Compose Scripts 
  - CI/CD for [Render](https://app-generator.dev/docs/deployment/render/index.html)

<br />

## [Documentation](https://app-generator.dev/docs/products/flask/adminlte/index.html)

- Understand the codebase structure
- Prepare the environment
- Setting Up the Database
- Start the Project
- Switch from SQLite to MySql or PgSql
- Add a new model and migrate database
- Enable Dynamic-Table for a new model
- Deploy on Render

![AdminLTE - Full-Stack Starter generated by AppSeed.](https://user-images.githubusercontent.com/51070104/168842202-9b80a957-a375-4e6d-8247-2cc459267a86.png)

<br />

## Deploy on `Render`

[![Deploy to Render](https://render.com/images/deploy-to-render-button.svg)](https://render.com/deploy)

<br />

## [AdminLTE PRO Version](https://app-generator.dev/product/adminlte-pro/flask/)

> The premium version provides more features, priority on support, and is more often updated - [Live Demo](https://flask-adminlte-pro.onrender.com/charts/)

- Simple, Easy-to-Extend Codebase
- [AdminLTE](https://app-generator.dev/product/adminlte/) Design Integration 
- Bootstrap Styling 
- DB Persistence: SQLite (default), can be used with MySql, PgSql
- Authentication
   - Session-based 
   - OAuth GitHub, Google
- Apps:
  - Dynamic Tables - see [DEMO](https://flask-adminlte-pro.onrender.com/dynamic-dt/product)
  - Charts - see [DEMO](https://flask-adminlte-pro.onrender.com/charts/)
  - Media Files Manager
  - Celery (async tasks)
- [Deployment](https://app-generator.dev/docs/deployment.html)
  - Docker/Docker Compose Scripts 
  - CI/CD for [Render](https://app-generator.dev/docs/deployment/render/index.html)

![Flask AdminLTE - The premium version: API, Charts, React Intergration, Dynamic DT, and Docker Support.](https://github.com/user-attachments/assets/892dd62b-2127-4a8c-ba44-932999fdddbc)

<br />


## `Customize` with [Flask Generator](https://app-generator.dev/tools/flask-generator/)

- Access the [Flask Generator](https://app-generator.dev/tools/flask-generator/)
- Select the preferred design
- (Optional) Design Database: edit models and fields
- (Optional) Edit the fields for the extended user model
- (Optional) Enable OAuth for GitHub
- (Optional) Add Celery (async tasks)
- (Optional) Enable Dynamic Tables Module
- Docker Scripts
- Render CI/Cd Scripts

**The generated Flask project is available as a ZIP Archive and also uploaded to GitHub.**

![Flask Generator - Flask App Generator - User Interface for choosing the Design](https://github.com/user-attachments/assets/fbf73fc0-e9a1-4f01-86a8-aa8be55413b5) 

![Flask App Generator - User Interface for Edit the Extended User Model](https://github.com/user-attachments/assets/138b9816-4f2e-454f-84f2-7409969b8548) 

---
[Flask AdminLTE](https://app-generator.dev/product/adminlte/flask/) - Open-Source **Flask** Starter provided by [App Generator](https://app-generator.dev)
